## Lyftdata

Welcome to Lyftdata! This documentation provides brief instructions on how to install and configure Lyftdata on your
infrastructure.
For a detailed guide, refer to the [Lyftdata documentation](https://docs.lyftdata.com/).

Also, feel free to join our community on [Discourse](https://community.lyftdata.com) for any queries or feedback.

### New: WebSocket connectors (preview)

Looking to experiment with the new WebSocket input/output paths? See [docs/runtime/websocket.md](docs/runtime/websocket.md) for a minimal quick start, security notes, and feature flag details.

## Installation

To install Lyftdata, follow the steps below:

1. Obtain a [license](https://docs.lyftdata.com/start/licensing/).
2. Download a [binary](https://docs.lyftdata.com/start/downloads/).
3. Configure and run the Server.
4. Optionally, add additional Workers.

## Quick Start on Linux (x86_64)

To quickly install Lyftdata on a Linux system, follow the steps below:

1. Download the latest binary from
   the [Lyftdata CDN](https://dist.lyftdata.com/downloads/latest/lyftdata-x86_64-unknown-linux-gnu.tar.xz).
2. Extract the binary to a directory of your choice.

> **Note:** The binary is a `xz` compressed tarball. You can extract it using the following command:
> ```sh
> tar -xxf lyftdata-x86_64-unknown-linux-gnu.tar.xz
> ```

3. Copy the binary to a directory in your `PATH` environment variable.

> **Note:** You may copy the binary to the `/usr/local/bin`  which normally is a directory in your `PATH`
> environment variable using the following command:
> ```sh
> sudo cp lyftdata /usr/local/bin
> ```

4. Run the following command to start the Lyftdata Server:

```sh
lyftdata run server
```

> **Note:** The Server will start on `localhost:3000` by default. You can access the Server via a browser at
> `http://localhost:3000`.
> You will need the randomly generated password for the default `admin` which is displayed on the console when you start
> the Server.

For more detailed instructions and other platforms refer to the [Lyftdata documentation](https://docs.lyftdata.com/).

## Development Artifacts

- All web builds now write to `target/web/<project>` (for example: `target/web/lyftdata-ui/build`).
- Frontend caches such as `.svelte-kit`, `.astro`, and Vite bundles also live under the same `target/web/<project>` root.
- `npm install` creates a junction/symlinked `node_modules` that points into `target/node/<project>`, keeping dependencies out of the app directories.
- The shared location respects `LYFTDATA_TARGET_DIR`/`CARGO_TARGET_DIR`; override those to move artifacts elsewhere.
- Remove any stale `apps/*/*/build` or `dist` directories left from prior builds to avoid confusion (they are no longer used).

